package gov.va.med.domain.service;

import gov.va.med.domain.service.config.MhvConfigService;
import gov.va.med.framework.BaseService;
import gov.va.med.framework.logging.ILogger;
import gov.va.med.framework.logging.LoggerFactory;

/**
 * Provides basic services for MHV Domain. General usage of this class would be to 
 * extend your class from this one and start using services provided in this class as well as 
 * in its parent class called BaseService.
 * @author PII
 * @version $Id: MhvBaseService.java,v 1.1.1.1 2005/05/13 19:40:40 jon.crater Exp $
 * @since MHV 2.0
 */
public class MhvBaseService extends BaseService { 
    private static ILogger logger = null;
    
    /**
     * Provide the name of the logger for the application
     */
    public String getLoggerName() {
        return MhvConfigService.getInstance().getLoggerName();
    }

    /**
     * Provide the default Logger type an application in this domain
     */
    public int getLoggerType() {
        return LoggerFactory.WL_NONCATALOG_LOGGER;
    }
    
           
    /**
     * Creates an instance of the class
     */
    public MhvBaseService() {
        super();
    }
    
     public static ILogger getMhvLogger() {
        synchronized (MhvBaseService.class) {
            if (logger == null) {
                MhvBaseService service = new MhvBaseService();
                logger = service.getLogger();
            }   
        }   
        return logger;
    }
} 
